﻿[
/*----------------------------------------------------------------------------

[lp_header_nocache]
Via http header, sets the content to immediately expire, no caching.

Author: Bil Corry
Last Modified: Sep. 02, 2006
License: Public Domain

Description:
Via http header, sets the content to immediately expire, no caching.


Sample Usage:
lp_header_nocache;  // that's it!

Downloaded from tagSwap.net on Feb. 14, 2007.
Latest version available from <http://tagSwap.net/lp_header_nocache>.

----------------------------------------------------------------------------*/
		
]

[

define_tag:'lp_header_nocache',
	-description='Via http header, sets the content to immediately expire, no caching.',
	-priority='replace';
	
	$__http_header__->(replace: 'HTTP/1.0', 'HTTP/1.1');
	$__http_header__ += 'Expires: -1\r\n';
	$__http_header__ += 'Last-Modified: ' + (date_localtoGMT: date )->(format:'%a, %d %b %Y %H:%M:%S') + ' GMT\r\n';
	$__http_header__ += 'Cache-Control: no-store, no-cache, must-revalidate, no-transform, max-age=0, post-check=0, pre-check=0\r\n';
	$__http_header__ += 'Pragma: no-cache\r\n';
	if: !$__http_header__->(contains:'vary:');
		$__http_header__ += 'Vary: *\r\n';
	/if;
	if: !$__http_header__->(contains:'ETag:');
		$__http_header__ += 'ETag: "'Lasso_UniqueID'"\r\n';
	/if;
/define_tag;

]